/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.IntConsumer;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.protocol.Connection;
import pl.skidam.automodpack_core.protocol.PreValidationConnection;

public class DownloadClient
implements AutoCloseable {
    private final List<Connection> connections = new ArrayList<Connection>();
    private InetSocketAddress address = null;

    public DownloadClient(Jsons.ModpackAddresses modpackAddresses, byte[] secretBytes, int poolSize, Function<X509Certificate, Boolean> trustedByUserCallback) throws IOException {
        KeyStore keyStore;
        if (poolSize < 1) {
            throw new IllegalArgumentException("Pool size must be greater than 0");
        }
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Failed to create a KeyStore of the default type.", e);
        }
        try {
            keyStore.load(null);
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("Failed to load empty KeyStore", e);
        }
        PreValidationConnection firstConnection = this.getPreValidationConnection(modpackAddresses, keyStore);
        if (firstConnection.getSocket() != null && !firstConnection.getSocket().isClosed() && firstConnection.getUnvalidatedCertificate() == null && secretBytes != null) {
            this.connections.add(new Connection(firstConnection, secretBytes));
        } else if (firstConnection.getSocket() != null) {
            firstConnection.getSocket().close();
        }
        if (trustedByUserCallback != null && firstConnection.getUnvalidatedCertificate() != null && trustedByUserCallback.apply(firstConnection.getUnvalidatedCertificate()).booleanValue()) {
            try {
                keyStore.setCertificateEntry(modpackAddresses.hostAddress.getHostString(), firstConnection.getUnvalidatedCertificate());
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Could not add the trusted certificate to the KeyStore.", e);
            }
        }
        if (secretBytes == null) {
            return;
        }
        for (int i = this.connections.size(); i < poolSize; ++i) {
            PreValidationConnection preValidationConnection = this.getPreValidationConnection(modpackAddresses, keyStore);
            this.connections.add(new Connection(preValidationConnection, secretBytes));
        }
    }

    private PreValidationConnection getPreValidationConnection(Jsons.ModpackAddresses modpackAddresses, KeyStore keyStore) throws IOException {
        PreValidationConnection preValidationConnection;
        try {
            String hostName = modpackAddresses.hostAddress.getHostString();
            if (this.address == null) {
                InetSocketAddress resolvedInetSocketAddress = new InetSocketAddress(hostName, modpackAddresses.hostAddress.getPort());
                if (resolvedInetSocketAddress.isUnresolved()) {
                    throw new IOException("Failed to resolve host address: " + hostName);
                }
                this.address = resolvedInetSocketAddress;
            }
            preValidationConnection = new PreValidationConnection(this.address, modpackAddresses, keyStore);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Failed to establish connection due to an issue with the generated KeyStore.", e);
        }
        return preValidationConnection;
    }

    public static DownloadClient tryCreate(Jsons.ModpackAddresses modpackAddresses, byte[] secretBytes, int poolSize, Function<X509Certificate, Boolean> trustedByUserCallback) {
        try {
            return new DownloadClient(modpackAddresses, secretBytes, poolSize, trustedByUserCallback);
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Failed to create a download client. Error: {}", (Object)e.getMessage());
            GlobalVariables.LOGGER.debug((Object)e);
            return null;
        }
    }

    private synchronized Connection getFreeConnection() {
        Iterator<Connection> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection conn = iterator.next();
            if (conn.isBusy()) continue;
            if (!conn.isActive()) {
                iterator.remove();
                return this.getFreeConnection();
            }
            conn.setBusy(true);
            return conn;
        }
        throw new IllegalStateException("No available connections");
    }

    public CompletableFuture<Path> downloadFile(byte[] fileHash, Path destination, IntConsumer chunkCallback) {
        Connection conn = this.getFreeConnection();
        return conn.sendDownloadFile(fileHash, destination, chunkCallback);
    }

    public CompletableFuture<Path> requestRefresh(byte[][] fileHashes, Path destination) {
        Connection conn = this.getFreeConnection();
        return conn.sendRefreshRequest(fileHashes, destination);
    }

    @Override
    public void close() {
        for (Connection conn : this.connections) {
            conn.close();
        }
        this.connections.clear();
    }
}

